//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.alignment.commands;


import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.plugin.alignment.SmithWaterman;
import de.ugoe.cs.autoquest.plugin.alignment.seqgen.SimpleSequenceGenerator;
import de.ugoe.cs.autoquest.plugin.alignment.substitution.NearbySubstitutionMatrix;
import de.ugoe.cs.autoquest.plugin.alignment.substitution.ObjectDistanceSubstitionMatrix;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to generate a binary alignment of two sequences
 * </p>
 * 
 * @author Ralph Krimmel
 * @version 1.0
 */
public class CMDgenerateSubstitutionMatrix implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@SuppressWarnings("unchecked")
	public void run(List<Object> parameters) {
		String sequencesName = "numberSequences";
		try {
			sequencesName = (String) parameters.get(0);
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

		Collection<List<Event>> sequences = new LinkedList<List<Event>>();
		Object obj = GlobalDataContainer.getInstance().getData(sequencesName);
		if(obj != null) {
			
			if(obj.getClass().equals(sequences.getClass())) {
				sequences = (Collection<List<Event>>) obj;
			}
		 
				
					Console.println("Number of sequences: " + sequences.size());

					SimpleSequenceGenerator gen = new SimpleSequenceGenerator();
					gen.generate(sequences);
					gen.print();
					GlobalDataContainer.getInstance().addData("numberSequences", gen);
				

				
				
				}
			}


	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
    public String help() {
                  return "generateSubstitutionMatrix <NumberSequencesName> {<algorithm>}";
    }
  

}
