package de.ugoe.cs.eventbench.swt;

import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;

public class GenerateSequencesDialog extends Dialog {

	protected Object result;
	protected Shell shlGenerateSequences;
	private Text text;
	private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());

	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public GenerateSequencesDialog(Shell parent, int style) {
		super(parent, style);
		setText("SWT Dialog");
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public Object open() {
		createContents();
		shlGenerateSequences.open();
		shlGenerateSequences.layout();
		Display display = getParent().getDisplay();
		while (!shlGenerateSequences.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shlGenerateSequences = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		shlGenerateSequences.setSize(201, 248);
		shlGenerateSequences.setText("Generate Sequences");
		shlGenerateSequences.setLayout(new GridLayout(2, false));
		
		Group group = new Group(shlGenerateSequences, SWT.NONE);
		group.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		group.setText("Name");
		group.setLayout(new GridLayout(1, false));
		
		text = new Text(group, SWT.BORDER);
		text.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Group grpNumber = new Group(shlGenerateSequences, SWT.NONE);
		grpNumber.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		grpNumber.setText("Number");
		grpNumber.setLayout(new GridLayout(2, false));
		
		Spinner spinner = new Spinner(grpNumber, SWT.BORDER);
		spinner.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Button btnAll = new Button(grpNumber, SWT.CHECK);
		btnAll.setText("All");
		
		Group grpLength = new Group(shlGenerateSequences, SWT.NONE);
		grpLength.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		grpLength.setText("Length");
		grpLength.setLayout(new GridLayout(4, false));
		
		Button btnAll_1 = new Button(grpLength, SWT.CHECK);
		btnAll_1.setText("All");
		new Label(grpLength, SWT.NONE);
		new Label(grpLength, SWT.NONE);
		new Label(grpLength, SWT.NONE);
		
		Label label = new Label(grpLength, SWT.NONE);
		label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		label.setText("Min.");
		
		Spinner spinner_2 = new Spinner(grpLength, SWT.BORDER);
		spinner_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label label_1 = new Label(grpLength, SWT.NONE);
		label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, true, 1, 1));
		label_1.setText("Max.");
		
		Spinner spinner_1 = new Spinner(grpLength, SWT.BORDER);
		spinner_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinner_1.setToolTipText("0 means no limitations");
		
		Button btnGenerate = formToolkit.createButton(shlGenerateSequences, "Generate!", SWT.NONE);
		
		Button btnAbort = formToolkit.createButton(shlGenerateSequences, "Abort", SWT.NONE);

	}
}
