//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import static de.ugoe.cs.autoquest.usability.UsabilitySmellDescription.GOOD_DEFAULTS;

import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.autoquest.usability.UsabilitySmell;

/**
 *
 */
public class DefaultValueRuleTest extends AbstractUsabilityEvaluationTC {

    /**
     *
     */
    @Before
    public void setUp() {
        //UsabilitySmellIntensity.defaultCoverageQuantile = 0;
    }
    
    /**
     *
     */
    @Test
    public void testNoValueSelections_01() {
        DefaultValueRule rule = new DefaultValueRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Interaction elem1 {}" +
            "  Interaction elem1 {}" +
            "}";
        
        // no smell expected, as there are no value selections
        UsabilitySmell[] expectedSmells = new UsabilitySmell[] {  };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }
    
    /**
     *
     */
    @Test
    public void testNoValueSelections_02() {
        DefaultValueRule rule = new DefaultValueRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    Interaction elem1 {}" +
            "    Interaction elem2 {}" +
            "  }" +
            "}";
        
        // no smell expected, as there are no value selections
        UsabilitySmell[] expectedSmells = new UsabilitySmell[] {  };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }
    
    /**
     *
     */
    @Test
    public void testNoValueSelections_03() {
        DefaultValueRule rule = new DefaultValueRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    MouseClick elem1 {}" +
            "    MouseClick elem2 {}" +
            "  }" +
            "}";
        
        // no smell expected, as there are no value selections
        UsabilitySmell[] expectedSmells = new UsabilitySmell[] {  };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }

    /**
     *
     */
    @Test
    public void testSeveralValueSelections_01() {
        DefaultValueRule rule = new DefaultValueRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "  }" +
            "}";
        
        UsabilitySmell[] expectedSmells = new UsabilitySmell[]
            { new UsabilitySmell(UsabilitySmellIntensity.getIntensity(0), GOOD_DEFAULTS) };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }

    /**
     *
     */
    @Test
    public void testSeveralValueSelections_02() {
        DefaultValueRule rule = new DefaultValueRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "  }" +
            "}";
        
        UsabilitySmell[] expectedSmells = new UsabilitySmell[]
            { new UsabilitySmell(UsabilitySmellIntensity.getIntensity(0), GOOD_DEFAULTS) };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }

    /**
     *
     */
    @Test
    public void testSeveralValueSelections_03() {
        DefaultValueRule rule = new DefaultValueRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "  }" +
            "}";
        
        // equally distributed, so no smell detected
        UsabilitySmell[] expectedSmells = new UsabilitySmell[] { };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }

    /**
     *
     */
    @Test
    public void testSeveralValueSelections_04() {
        DefaultValueRule rule = new DefaultValueRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "  }" +
            "}";
        
        // equally distributed, so no smell detected
        UsabilitySmell[] expectedSmells = new UsabilitySmell[] { };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }

    /**
     *
     */
    @Test
    public void testSeveralValueSelections_05() {
        DefaultValueRule rule = new DefaultValueRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value4) {}" +
            "    TextInput elem1 (value4) {}" +
            "    TextInput elem1 (value4) {}" +
            "    TextInput elem1 (value4) {}" +
            "    TextInput elem1 (value2) {}" +
            "  }" +
            "}";
        
        // equally distributed, so no smell detected
        UsabilitySmell[] expectedSmells = new UsabilitySmell[] { };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }

    /**
     *
     */
    @Test
    public void testSeveralValueSelections_06() {
        DefaultValueRule rule = new DefaultValueRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value3) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value2) {}" +
            "    TextInput elem1 (value1) {}" +
            "    TextInput elem1 (value4) {}" +
            "    TextInput elem1 (value4) {}" +
            "    TextInput elem1 (value4) {}" +
            "    TextInput elem1 (value4) {}" +
            "    TextInput elem1 (value2) {}" +
            "  }" +
            "}";
        
        UsabilitySmell[] expectedSmells = new UsabilitySmell[]
            { new UsabilitySmell(UsabilitySmellIntensity.getIntensity(0), GOOD_DEFAULTS) };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }
}
