package de.ugoe.cs.eventbench.swt;

import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;

public class CommandHistoryDialog extends Dialog {

	protected Object result;
	protected Shell shell;

	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public CommandHistoryDialog(Shell parent, int style) {
		super(parent, style);
		setText("SWT Dialog");
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), SWT.DIALOG_TRIM);
		shell.setSize(450, 300);
		shell.setText(getText());
		shell.setLayout(new GridLayout(3, false));
		
		Label lblRecentCommands = new Label(shell, SWT.NONE);
		lblRecentCommands.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));
		lblRecentCommands.setText("Recent Commands:");
		new Label(shell, SWT.NONE);
		
		List list = new List(shell, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		list.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));
		
		Button btnExec = new Button(shell, SWT.NONE);
		btnExec.setText("Execute");
		
		Button btnCopyToClipboard = new Button(shell, SWT.NONE);
		btnCopyToClipboard.setText("Copy to Clipboard");
		
		Button btnCreateBatchfile = new Button(shell, SWT.NONE);
		btnCreateBatchfile.setText("Create Batchfile");

	}
}
