//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.httpmonitor;

/**
 * <p>
 * used to be able to shut down any {@link HttpMonitorComponent} that must be stopped if the
 * application stops.
 * </p>
 * 
 * @author Patrick Harms
 */
public class ShutdownHook implements Runnable {

    /**
     * the components to be stopped on shutdown
     */
    private HttpMonitorComponent[] components;
    
    /**
     * <p>
     * initializes the shutdown hook with the components to be shut down on shutdown of the whole
     * application
     * </p>
     *
     */
    public ShutdownHook(HttpMonitorComponent... components) {
        this.components = components;
    }

    /* (non-Javadoc)
     * @see java.lang.Thread#run()
     */
    @Override
    public void run() {
        for (HttpMonitorComponent component : components) {
            if (component != null) {
                try {
                    component.stop();
                }
                catch (Exception e) {
                    // ignore and go on
                }
            }
        }
    }

}
