/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.eventbench.jfcmonitor;

import de.ugoe.cs.eventbench.jfcmonitor.JFCComponent;
import de.ugoe.cs.util.StringTools;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class JFCListener
implements AWTEventListener {
    private final OutputStreamWriter outputWriter;

    public JFCListener(OutputStreamWriter outputWriter) {
        this.outputWriter = outputWriter;
        try {
            outputWriter.write("<?xml version=\"1.0\" encoding=\"UTF-16\"?>" + StringTools.ENDLINE);
            outputWriter.write("<sessions>" + StringTools.ENDLINE);
        }
        catch (IOException e) {
            System.err.println("JFCMONITOR -- Failure writing to log: " + e.getMessage());
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        StringBuilder builder = new StringBuilder();
        if (event instanceof MouseEvent) {
            if (!this.isMouseMovement(event.getID())) {
                MouseEvent mouseEvent = (MouseEvent)event;
                builder.append("<event id=\"" + event.getID() + "\">" + StringTools.ENDLINE);
                builder.append(" <param name=\"X\" value=\"" + mouseEvent.getX() + "\" />" + StringTools.ENDLINE);
                builder.append(" <param name=\"Y\" value=\"" + mouseEvent.getY() + "\" />" + StringTools.ENDLINE);
                builder.append(" <param name=\"Button\" value=\"" + mouseEvent.getButton() + "\" />" + StringTools.ENDLINE);
                builder.append(" <param name=\"Modifiers\" value=\"" + mouseEvent.getModifiers() + "\" />" + StringTools.ENDLINE);
                this.addSourceInfo(builder, event);
                builder.append("</event>" + StringTools.ENDLINE);
            }
        } else if (event instanceof KeyEvent) {
            if (event.getID() == 401 || event.getID() == 402) {
                KeyEvent keyEvent = (KeyEvent)event;
                builder.append("<event id=\"" + event.getID() + "\">" + StringTools.ENDLINE);
                builder.append(" <param name=\"KeyCode\" value=\"" + keyEvent.getKeyCode() + "\" />" + StringTools.ENDLINE);
                builder.append(" <param name=\"Modifiers\" value=\"" + keyEvent.getModifiers() + "\" />" + StringTools.ENDLINE);
                this.addSourceInfo(builder, event);
                builder.append("</event>" + StringTools.ENDLINE);
            }
        } else if (event instanceof FocusEvent && event.getID() == 1004) {
            builder.append("<event id=\"" + event.getID() + "\">" + StringTools.ENDLINE);
            this.addSourceInfo(builder, event);
            builder.append("</event>" + StringTools.ENDLINE);
        }
        if (builder.length() > 0 && this.outputWriter != null) {
            try {
                this.outputWriter.write(builder.toString());
                this.outputWriter.flush();
            }
            catch (IOException e) {
                System.err.println("JFCMONITOR -- Failure writing to log: " + e.getMessage());
            }
        }
    }

    private void addSourceInfo(StringBuilder builder, AWTEvent event) {
        Component source;
        JFCComponent jfcComponent;
        builder.append(" <source>" + StringTools.ENDLINE);
        builder.append("  <param name=\"toString\" value=\"" + StringTools.xmlEntityReplacement((String)event.getSource().toString()) + "\" />" + StringTools.ENDLINE);
        if (event.getSource() instanceof Component && (jfcComponent = JFCComponent.find(source = (Component)event.getSource())) != null) {
            builder.append(jfcComponent.getXML());
        }
        builder.append(" </source>" + StringTools.ENDLINE);
    }

    private boolean isMouseMovement(int eventId) {
        return eventId == 503 || eventId == 506 || eventId == 504 || eventId == 505;
    }
}

