package de.ugoe.cs.eventbench.assertions;

import de.ugoe.cs.eventbench.data.IReplayable;
import de.ugoe.cs.util.StringTools;

public class FileEqualsReplay implements IReplayable {

	String actualFile = null;
	String expectedFile = null;
	/**
	 * Id for object serialization.
	 */
	private static final long serialVersionUID = 1L;

	public void setActualFile(String s) {
		actualFile = s;
	}

	public void setExpectedFile(String s) {
		expectedFile = s;
	}

	public String getReplay() {

		actualFile = StringTools.xmlEntityReplacement(actualFile);
		expectedFile = StringTools.xmlEntityReplacement(expectedFile);

		StringBuilder currentMsgStr = new StringBuilder(800);
		currentMsgStr.append("  <fileEquals ");
		currentMsgStr.append("actualFile=\"" + actualFile + "\" ");
		currentMsgStr.append("expectedFile=\"" + expectedFile + "\"/>");
		currentMsgStr.append(StringTools.ENDLINE);
		return currentMsgStr.toString();
	}

	public String getTarget() {
		return "targetNotUsed";
	}

}
