//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.util.console.defaultcommands;

import java.util.List;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to list all events (symbols) known to a usage profile (stochastic process).
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDlistCommands implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        Command[] commands = CommandExecuter.getInstance().getAvailableCommands();

        List<String> commandPackages = CommandExecuter.getInstance().getCommandPackages();

        for (String commandPackage : commandPackages) {
            String[] packageSplit = commandPackage.split("\\.");
            if (packageSplit[packageSplit.length - 1].equals("commands")) {
                Console.println(packageSplit[packageSplit.length - 2]);
            }
            else if (packageSplit[packageSplit.length - 1].equals("defaultcommands")) {
                Console.println("general");
            }
            else {
                Console.println(packageSplit[packageSplit.length - 1]);
            }
            for (Command command : commands) {
                if (commandPackage.equals(command.getClass().getPackage().getName())) {
                    Console.println("   " + command.help());
                }
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "listCommands";
    }

}
