package de.ugoe.cs.eventbench.efg.commands;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.efg.data.EFGEvent;
import de.ugoe.cs.eventbench.models.FirstOrderMarkovModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import edu.umd.cs.guitar.model.GUITARConstants;
import edu.umd.cs.guitar.model.IO;
import edu.umd.cs.guitar.model.data.EFG;
import edu.umd.cs.guitar.model.data.EventGraphType;
import edu.umd.cs.guitar.model.data.EventType;

/**
 * <p>
 * Command to that loads an EFG and creates a first-order Markov model with the
 * same structure.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDefgToMM implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		String modelname;
		try {
			filename = (String) parameters.get(0);
			modelname = (String) parameters.get(1);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		EFG efg = (EFG) IO.readObjFromFile(filename, EFG.class);

		// extracting the events from the EFG
		List<EventType> efgEvents = efg.getEvents().getEvent();
		List<Event<?>> myEvents = new ArrayList<Event<?>>(efgEvents.size());
		for (EventType event : efgEvents) {
			/*
			 * the widgetId and eventId are only hash values, 
			 * the "interpretation" is found in the GUI file. 
			 */
			String eventTarget = event.getWidgetId();
			String eventId = event.getEventId();
			
			/* 
			 * Not sure what these are used for.
			String eventType = event.getType();
			String eventAction = event.getAction();
			 */

			Event<?> myEvent = new EFGEvent(eventId);
			myEvent.setTarget(eventTarget);
			myEvents.add(myEvent);
		}

		// extracting graph structure from the EFG
		/*
		 * getEventGraph returns an adjacency matrix, i.e., a square matrix of
		 * efgEvents.size(), where a 1 in row i, column j means an edge
		 * efgEvents.get(i)->efgEvents.get(j) exists.
		 */
		EventGraphType efgGraph = efg.getEventGraph();

		FirstOrderMarkovModel model = new FirstOrderMarkovModel(new Random());
		Collection<List<Event<?>>> subsequences = new LinkedList<List<Event<?>>>();

		int efgSize = efgEvents.size();
		for (int row = 0; row < efgSize; row++) {
			for (int col = 0; col < efgSize; col++) {
				int relation = efgGraph.getRow().get(row).getE().get(col);
				// otherEvent is followed by currentEvent
				if (relation != GUITARConstants.NO_EDGE) {
					List<Event<?>> edge = new LinkedList<Event<?>>();
					edge.add(myEvents.get(row));
					edge.add(myEvents.get(col));
					subsequences.add(edge);
				}
			}
		}
		model.train(subsequences);
		GlobalDataContainer.getInstance().addData(modelname, model);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: efgToMM <filename> <modelname>");
	}

}
