/*
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.io.Serializable;

// TODO: Auto-generated Javadoc
/**
 * The Class StaticTriangleMatrix.
 */
public class StaticTriangleMatrix implements ITriangleMatrix, Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 7599542322424894866L;
	
	/** The matrix. */
	private final float[] matrix;
	
	/** The size. */
	protected int size;

	/**
	 * Instantiates a new static triangle matrix.
	 *
	 * @param size the size
	 */
	public StaticTriangleMatrix(int size) {
		this.size = size;
		matrix = new float[(size * (size + 1)) / 2];
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#get(int, int)
	 */
	@Override
	public float get(int first, int second) {
		final int row = Math.min(first, second);
		final int col = Math.max(first, second);
		return matrix[(row * size) - (((row * (row + 1)) / 2) - (size - col))];

	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#increaseSize(int)
	 */
	@Override
	public void increaseSize(int count) throws Exception {
		throw new Exception(
				"Cannot call this function on this implementation of ITriangle Matrix");

	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#initialize(float)
	 */
	@Override
	public void initialize(float value) {
		for (int i = 0; i < matrix.length; i++) {
			matrix[i] = value;
		}
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#set(int, int, float)
	 */
	@Override
	public void set(int first, int second, float value) {
		final int row = Math.min(first, second);
		final int col = Math.max(first, second);
		matrix[(row * size) - (((row * (row + 1)) / 2) - (size - col))] = value;
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#size()
	 */
	@Override
	public int size() {
		return size;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		String result = "";
		for (int i = 0; i < size; i++) {
			for (int j = 0; j < size; j++) {
				if (i < j) {
					if (Float.isInfinite(this.get(i, j))) {
						result = result + " -------";
					} else {
						result = result
								+ String.format("%+8.2f", this.get(i, j));
					}
				} else {
					result = result + ("        ");
				}
			}
			result = result + "\n";
		}
		return result;
	}
}
