//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.http.eventcore;

import static org.junit.Assert.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.set.ListOrderedSet;
import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.plugin.http.HTTPLogParser;
import de.ugoe.cs.autoquest.plugin.http.SOAPUtils;
import de.ugoe.cs.autoquest.plugin.http.eventcore.EqualSOAPDataMap;
import de.ugoe.cs.autoquest.plugin.http.eventcore.SimpleSOAPEventType;

/**
 * @author Steffen Herbold
 */
public class EqualSOAPDataMapTest {

    /**
     * 
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testSerialization_1() throws Exception {
        HTTPLogParser parser =
            new HTTPLogParser(new File(ClassLoader
                .getSystemResource("testParseFile_3_properties.txt").getFile()));
        parser.parseFile(new File(ClassLoader.getSystemResource("testParseFile_3_logfile.log")
            .getFile()));
        for (List<Event> sequence : parser.getSequences()) {
            SOAPUtils.convertToSimpleSOAPEvent(sequence, true);
        }

        Field privateStringField = EqualSOAPDataMap.class.getDeclaredField("soapRequestBodies");

        privateStringField.setAccessible(true);

        Map<SimpleSOAPEventType, ListOrderedSet<String>> internalMapExpected =
            (Map<SimpleSOAPEventType, ListOrderedSet<String>>) privateStringField
                .get(EqualSOAPDataMap.getInstance());

        // serialize
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(EqualSOAPDataMap.getInstance());
        oos.close();

        EqualSOAPDataMap.getInstance().reset();

        // deserialize
        byte[] pickled = out.toByteArray();
        InputStream in = new ByteArrayInputStream(pickled);
        ObjectInputStream ois = new ObjectInputStream(in);
        ois.readObject();
        ois.close();

        Map<SimpleSOAPEventType, ListOrderedSet<String>> internalMapResult =
            (Map<SimpleSOAPEventType, ListOrderedSet<String>>) privateStringField
                .get(EqualSOAPDataMap.getInstance());

        assertNotSame(internalMapExpected, internalMapResult);
        assertEquals(internalMapExpected, internalMapResult);
    }

}
