//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usageprofiles;

import java.io.Serializable;

/**
 * <p>
 * This interface can be used for implementing comparison strategies for symbols.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface SymbolComparator<T> extends Serializable {
    
    /**
     * <p>
     * compares two symbols and returns true, if the concrete comparison strategy sees both
     * symbols as equal. The method must be commutative and transitive, i.e.,
     * <code>equals(symbol1, symbol2) == equals(symbol2, symbol1)</code> and
     * <code>if (equals(symbol1, symbol2) && equals(symbol2, symbol3)) then
     * equals(symbol1, symbol3)</code>.
     * </p>
     *
     * @param symbol1 the first symbol to be compared
     * @param symbol2 the second symbol to be compared
     * 
     * @return true if the comparison strategy sees both symbols as equal, false else.
     */
    public boolean equals(T symbol1, T symbol2);

}
