package de.ugoe.cs.eventbench.markov;

import java.util.Random;

import de.ugoe.cs.eventbench.data.Event;

public abstract class State {
	
	/**
	 * {@link Event} associated with the state. 
	 */
	private Event<?> action;
	
	/**
	 * Identifier of the state
	 */
	private String id;
	
	/**
	 * Random number generator used for state transmissions. 
	 */
	protected Random rand;
	
	/**
	 * State transmission function to be used by models. 
	 * @return
	 */
	public abstract State getNextState();
	
	/**
	 * Creates a new State object. The id should be unique.
	 * @param id identifier string of the state
	 */
	protected State(String id, Event<?> action) {
		this.id = id;
		this.action = action;
	}

	/**
	 * Dummy method for history-less state implementations.
	 */
	public void setHistoryObject() {}
	
	/**
	 * Defines a random number generator to be used by getNextState.
	 * @param r Random number generator
	 */
	public void setRandom(Random r) {
		rand = r;
	}
	
	/**
	 * Returns the id of the state. 
	 * @return id of the state
	 */
	public String getId() {
		return id;
	}
	
	/**
	 * The {@link Event} associated with this state. 
	 * @return {@link Event} associated with this state
	 */
	public Event<?> getAction() {
		return action;
	}
	
	/**
	 * Two states are equal if their id string is equal.
	 */
	@Override
	public boolean equals(Object other) {
		if( other==this ) {
			return true;
		}
		boolean isEqual = false;
		if( other instanceof State ) {
			isEqual = id.equals(((State) other).id);
		}
		return isEqual;
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		int multiplier = 37;
		int hash = 42;
		
		hash = multiplier*hash + id.hashCode();
		
		return hash;
	}
	
}
