/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureRetained;

class AttributeBin
implements ObjectUpdate {
    RenderingAttributesRetained definingRenderingAttributes = null;
    EnvironmentSet environmentSet = null;
    AttributeBin next = null;
    AttributeBin prev = null;
    TextureBin textureBinList = null;
    ArrayList addTextureBins = new ArrayList();
    ArrayList addTBs = new ArrayList();
    boolean soleUser = false;
    AppearanceRetained app = null;
    ArrayList removeTBs = new ArrayList();
    int onUpdateList = 0;
    static int ON_OBJ_UPDATE_LIST = 1;
    static int ON_CHANGED_FREQUENT_UPDATE_LIST = 2;
    boolean ignoreVertexColors = false;
    RenderingAttributesRetained renderingAttrs;
    int numEditingTextureBins = 0;

    AttributeBin(AppearanceRetained appearanceRetained, RenderingAttributesRetained renderingAttributesRetained, RenderBin renderBin) {
        this.reset(appearanceRetained, renderingAttributesRetained, renderBin);
    }

    void reset(AppearanceRetained appearanceRetained, RenderingAttributesRetained renderingAttributesRetained, RenderBin renderBin) {
        this.prev = null;
        this.next = null;
        this.textureBinList = null;
        this.onUpdateList = 0;
        this.numEditingTextureBins = 0;
        this.renderingAttrs = renderingAttributesRetained;
        this.soleUser = appearanceRetained != null ? (appearanceRetained.changedFrequent & 0x40) != 0 : false;
        if (this.soleUser) {
            this.app = appearanceRetained;
        } else {
            appearanceRetained = null;
        }
        if (renderingAttributesRetained != null) {
            if (renderingAttributesRetained.changedFrequent != 0) {
                this.definingRenderingAttributes = renderingAttributesRetained;
                if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) == 0) {
                    renderBin.aBinUpdateList.add(this);
                    this.onUpdateList |= ON_CHANGED_FREQUENT_UPDATE_LIST;
                }
            } else if (this.definingRenderingAttributes != null) {
                this.definingRenderingAttributes.set(renderingAttributesRetained);
            } else {
                this.definingRenderingAttributes = (RenderingAttributesRetained)renderingAttributesRetained.clone();
            }
            this.ignoreVertexColors = this.definingRenderingAttributes.ignoreVertexColors;
        } else {
            this.definingRenderingAttributes = null;
            this.ignoreVertexColors = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean equals(RenderingAttributesRetained renderingAttributesRetained, RenderAtom renderAtom) {
        if (this.soleUser || renderAtom.geometryAtom.source.appearance != null && (renderAtom.geometryAtom.source.appearance.changedFrequent & 0x40) != 0) {
            if (this.app != renderAtom.geometryAtom.source.appearance) return false;
            if (this.numEditingTextureBins != 0) return true;
            if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) != 0) return true;
            this.environmentSet.renderBin.aBinUpdateList.add(this);
            this.onUpdateList |= ON_CHANGED_FREQUENT_UPDATE_LIST;
            return true;
        }
        if (this.definingRenderingAttributes == null) {
            if (renderingAttributesRetained == null) return true;
            return false;
        }
        if (this.definingRenderingAttributes.changedFrequent != 0 || renderingAttributesRetained != null && renderingAttributesRetained.changedFrequent != 0) {
            if (this.definingRenderingAttributes != renderingAttributesRetained) return false;
            if (this.definingRenderingAttributes.compChanged == 0) return true;
            if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) != 0) return true;
            this.environmentSet.renderBin.aBinUpdateList.add(this);
            this.onUpdateList |= ON_CHANGED_FREQUENT_UPDATE_LIST;
            return true;
        }
        if (this.definingRenderingAttributes.equivalent(renderingAttributesRetained)) return true;
        return false;
    }

    public void updateObject() {
        if (this.addTBs.size() > 0) {
            TextureBin textureBin = (TextureBin)this.addTBs.get(0);
            if (this.textureBinList == null) {
                this.textureBinList = textureBin;
            } else {
                this.insertTextureBin(textureBin);
            }
            int n = 1;
            while (n < this.addTBs.size()) {
                textureBin = (TextureBin)this.addTBs.get(n);
                this.insertTextureBin(textureBin);
                ++n;
            }
        }
        this.addTBs.clear();
        this.onUpdateList &= ~ON_OBJ_UPDATE_LIST;
    }

    void insertTextureBin(TextureBin textureBin) {
        TextureRetained textureRetained = null;
        if (textureBin.texUnitState != null && textureBin.texUnitState.length > 0 && textureBin.texUnitState[0] != null) {
            textureRetained = textureBin.texUnitState[0].texture;
        }
        if (textureRetained != null) {
            TextureBin textureBin2 = this.textureBinList;
            while (textureBin2 != null) {
                if (textureBin2.texUnitState == null || textureBin2.texUnitState[0] == null || textureBin2.texUnitState[0].texture != textureRetained) {
                    textureBin2 = textureBin2.next;
                    continue;
                }
                textureBin.next = textureBin2;
                textureBin.prev = textureBin2.prev;
                if (textureBin2.prev == null) {
                    this.textureBinList = textureBin;
                } else {
                    textureBin2.prev.next = textureBin;
                }
                textureBin2.prev = textureBin;
                return;
            }
        }
        textureBin.prev = null;
        textureBin.next = this.textureBinList;
        this.textureBinList.prev = textureBin;
        this.textureBinList = textureBin;
        textureBin.tbFlag &= 0xFFFFFFEF;
    }

    void reInsertTextureBin(TextureBin textureBin) {
        TextureRetained textureRetained = null;
        TextureRetained textureRetained2 = null;
        TextureRetained textureRetained3 = null;
        if (textureBin.texUnitState != null && textureBin.texUnitState[0] != null) {
            textureRetained = textureBin.texUnitState[0].texture;
        }
        if (textureBin.prev != null && textureBin.prev.texUnitState != null) {
            textureRetained2 = textureBin.prev.texUnitState[0].texture;
        }
        if (textureRetained != textureRetained2) {
            if (textureBin.next != null && textureBin.next.texUnitState != null) {
                textureRetained3 = textureBin.next.texUnitState[0].texture;
            }
            if (textureRetained != textureRetained3 && textureBin.prev != null && textureBin.next != null) {
                textureBin.prev.next = textureBin.next;
                textureBin.next.prev = textureBin.prev;
                this.insertTextureBin(textureBin);
            }
        }
    }

    void addTextureBin(TextureBin textureBin, RenderBin renderBin, RenderAtom renderAtom) {
        RenderingAttributesRetained renderingAttributesRetained;
        textureBin.attributeBin = this;
        AppearanceRetained appearanceRetained = renderAtom.geometryAtom.source.appearance;
        RenderingAttributesRetained renderingAttributesRetained2 = renderingAttributesRetained = appearanceRetained == null ? null : appearanceRetained.renderingAttributes;
        if (!this.soleUser && this.renderingAttrs != renderingAttributesRetained) {
            this.renderingAttrs = this.definingRenderingAttributes;
        }
        this.addTBs.add(textureBin);
        if ((this.onUpdateList & ON_OBJ_UPDATE_LIST) == 0) {
            this.onUpdateList |= ON_OBJ_UPDATE_LIST;
            renderBin.objUpdateList.add(this);
        }
    }

    void removeTextureBin(TextureBin textureBin) {
        textureBin.attributeBin = null;
        if (this.addTBs.contains(textureBin)) {
            this.addTBs.remove(this.addTBs.indexOf(textureBin));
        } else if (textureBin.prev == null) {
            this.textureBinList = textureBin.next;
            if (textureBin.next != null) {
                textureBin.next.prev = null;
            }
        } else {
            textureBin.prev.next = textureBin.next;
            if (textureBin.next != null) {
                textureBin.next.prev = textureBin.prev;
            }
        }
        textureBin.prev = null;
        textureBin.next = null;
        textureBin.clear();
        this.environmentSet.renderBin.textureBinFreelist.add(textureBin);
        if (this.textureBinList == null && this.addTBs.size() == 0) {
            this.environmentSet.removeAttributeBin(this);
        }
    }

    void render(Canvas3D canvas3D) {
        boolean bl;
        boolean bl2 = bl = this.definingRenderingAttributes == null || this.definingRenderingAttributes.visible;
        if (this.environmentSet.renderBin.view.viewCache.visibilityPolicy == 0 && !bl || this.environmentSet.renderBin.view.viewCache.visibilityPolicy == 1 && bl) {
            return;
        }
        canvas3D.setStateToUpdate(2, this);
        TextureBin textureBin = this.textureBinList;
        while (textureBin != null) {
            textureBin.render(canvas3D);
            textureBin = textureBin.next;
        }
    }

    void updateAttributes(Canvas3D canvas3D) {
        if ((canvas3D.canvasDirty & 0x200) != 0) {
            if (this.definingRenderingAttributes == null) {
                canvas3D.resetRenderingAttributes(canvas3D.ctx, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            } else {
                this.definingRenderingAttributes.updateNative(canvas3D.ctx, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            }
            canvas3D.renderingAttrs = this.renderingAttrs;
        } else if (canvas3D.renderingAttrs != this.renderingAttrs && canvas3D.attributeBin != this) {
            if (this.definingRenderingAttributes == null) {
                canvas3D.resetRenderingAttributes(canvas3D.ctx, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            } else {
                this.definingRenderingAttributes.updateNative(canvas3D.ctx, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            }
            canvas3D.renderingAttrs = this.renderingAttrs;
        }
        canvas3D.attributeBin = this;
        canvas3D.canvasDirty &= 0xFFFFFDFF;
    }

    void updateNodeComponent() {
        if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) != 0) {
            if (this.soleUser) {
                boolean bl = this.definingRenderingAttributes != null && this.definingRenderingAttributes != this.renderingAttrs;
                this.renderingAttrs = this.app.renderingAttributes;
                if (this.renderingAttrs == null) {
                    this.definingRenderingAttributes = null;
                    this.ignoreVertexColors = false;
                } else {
                    if (this.renderingAttrs.changedFrequent != 0) {
                        this.definingRenderingAttributes = this.renderingAttrs;
                    } else if (bl) {
                        this.definingRenderingAttributes.set(this.renderingAttrs);
                    } else {
                        this.definingRenderingAttributes = (RenderingAttributesRetained)this.renderingAttrs.clone();
                    }
                    this.ignoreVertexColors = this.definingRenderingAttributes.ignoreVertexColors;
                }
            } else {
                this.ignoreVertexColors = this.definingRenderingAttributes.ignoreVertexColors;
            }
        }
        this.onUpdateList &= ~ON_CHANGED_FREQUENT_UPDATE_LIST;
    }

    void incrActiveTextureBin() {
        ++this.numEditingTextureBins;
    }

    void decrActiveTextureBin() {
        --this.numEditingTextureBins;
    }
}

