//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.androidmonitor;

import java.util.ArrayList;
import java.util.List;

import android.view.View;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Florian Unger
 * @version 1.0
 */
public class AndroidMonitorCompositeOnClickListener implements
        View.OnClickListener {

    /**
     * <p>
     * Save all listeners which belongs to a single view in a list.
     * </p>
     */
    private List<View.OnClickListener> listeners;

    /**
     * 
     * <p>
     * Constructor. Creates a new AndroidMonitorCompositeOnClickListener.
     * </p>
     *
     */
    public AndroidMonitorCompositeOnClickListener() {
            listeners = new ArrayList<View.OnClickListener>();
    }

    /**
     * <p>
     * Add a listener to a single view.
     * </p>
     * 
     * @param listener
     */
    public void addOnClickListener(View.OnClickListener listener) {
            listeners.add(listener);
    }
    
    /* (non-Javadoc)
     * @see android.view.View.OnClickListener#onClick(android.view.View)
     */
    public void onClick(View v) {
        for (View.OnClickListener listener : listeners) {
            listener.onClick(v);
        }       
    }
}

/*
* (non-Javadoc)
* In Android it is not possible to have multiple onCliclListener for one view.
* This is also stated in
* http://books.google.de/books?id=bKo_1uED72EC&pg=PA178&lpg
* =PA178&dq=android+setonclicklistener
* +call+old+listener&source=bl&ots=g45T5ikRVK
* &sig=blIqJGMywqJEGNATe3WW5DZyS6M&hl
* =de&sa=X&ei=cl3rU6_8Ec2KOIzqgNgM&ved=0CEYQ6AEwBA
* #v=onepage&q=android%20setonclicklistener%20call%20old%20listener&f=false
* 
* Therefore it is necessary to have a custom class to handle a single onClick()
* and pass in handlers for it to call.
* http://stackoverflow.com/questions/7587299
* /android-multi-onclick-listener-in-one-button
*/