
package de.ugoe.cs.autoquest.plugin.usability2.statistics;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import com.google.common.collect.Maps;
import com.google.common.collect.Range;

public class Histogramm {

    final Map<Integer, Integer> data;

    public Histogramm() {
        this(new HashMap<Integer, Integer>());
    }

    private Histogramm(Map<Integer, Integer> data) {
        this.data = new HashMap<Integer, Integer>(data);
    }

    public Histogramm removeLessThan(int border) {
        Range<Integer> atLeast = Range.atLeast(border);
        Map<Integer, Integer> filtered =
            Maps.filterKeys(data, atLeast);
        return new Histogramm(filtered);
    }

    public void add(int value) {
        Integer count = data.get(value);
        int cnt;
        if (count == null) {
            cnt = 1;
        } else {
            cnt = count + 1;
        }
        
        System.out.print(".");
        
        data.put(value, cnt);
    }
    
    public int count(int offset) {
        int cnt = 0;
        System.out.println(data.size());
        
        for (Entry<Integer, Integer> entry : data.entrySet()) {
            cnt += (entry.getKey() + offset) * entry.getValue();
        }
        return cnt;
    }
    
    public int count() {
        return count(0);
    }
}
