#!/bin/sh

#   Copyright 2012 Georg-August-Universit�t G�ttingen, Germany
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.



# This script stops the autoquest-httpmonitor which is in the same folder as
# this script


# Absolute path to this script, e.g. /home/user/bin/stop.sh
SCRIPT=$(readlink -f $0)

# Find the autoquest-httpmonitor JAR-File and start in the Folder of this Script
JAR_FILE=`find $(dirname $SCRIPT) -type f -name 'autoquest-httpmonitor-*.jar'`

# Get the ProcessID of the autoquest-httpmonitor which is in the same folder as this script
PID=$(ps ax | grep "$JAR_FILE" | grep -v ' grep ' | grep ' proxy ' | awk '{print $1}')

if [ -z "$PID" ]; then
  echo autoquest-httpmonitoring proxy is not running
else
  #Kill this autoquest-httpmonitor-process
  kill "$PID"
  sleep 2
  # Check if Process is no more
  CHECK=$(ps ax | grep "$JAR_FILE" | grep -v ' grep ' | grep ' proxy ' | awk '{print $1}')
  if [ ! -z "$CHECK" ]; then
	kill -9 "$CHECK"
  fi
  echo autoquest-httpmonitoring proxy stopped
fi

