//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

// TODO: Auto-generated Javadoc
/**
 * <p>
 * This is an implementation of the visitor pattern. Through this, it is
 * possible to effectively process a task instance tree.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface ITaskInstanceVisitor {

	/**
	 * <p>
	 * method called for each visited event task instance.
	 * </p>
	 * 
	 * @param eventTaskInstance
	 *            the event task instance to be processed
	 */
	public void visit(IEventTaskInstance eventTaskInstance);

	/**
	 * <p>
	 * method called for each visited iteration instance.
	 * </p>
	 * 
	 * @param iterationInstance
	 *            the iteration instance to be processed
	 */
	public void visit(IIterationInstance iterationInstance);

	/**
	 * <p>
	 * method called for each visited optional instance.
	 * </p>
	 * 
	 * @param optionalInstance
	 *            the optional instance to be processed
	 */
	public void visit(IOptionalInstance optionalInstance);

	/**
	 * <p>
	 * method called for each visited selection instance.
	 * </p>
	 * 
	 * @param selectionInstance
	 *            the selection instance to be processed
	 */
	public void visit(ISelectionInstance selectionInstance);

	/**
	 * <p>
	 * method called for each visited sequence instance.
	 * </p>
	 * 
	 * @param sequenceInstance
	 *            the sequence instance to be processed
	 */
	public void visit(ISequenceInstance sequenceInstance);

	/**
	 * <p>
	 * method called for each other kind of visited task instance (implemented
	 * to support future versions).
	 * </p>
	 * 
	 * @param taskInstance
	 *            the task instance to be processed
	 */
	public void visit(ITaskInstance taskInstance);

}
