//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;

/**
 * <p>
 * Default implementation of {@link IEventTaskInstance}.
 * </p>
 * 
 * @author Patrick Harms
 */
class EventTaskInstance extends TaskInstance implements IEventTaskInstance {

    /**
     * <p>
     * default serial version UID
     * </p>
     */
    private static final long serialVersionUID = 1L;
    
    /**
     * <p>
     * the event represented by this instance
     * </p>
     */
    private Event event;

    /**
     * <p>
     * initializes this instance with the respective task model and the represented event
     * </p>
     *
     * @param task  the task of which this is an instance
     * @param event the event represented by this instance
     */
    EventTaskInstance(IEventTask task, Event event) {
        super(task);
        this.event = event;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance#getEvent()
     */
    @Override
    public Event getEvent() {
        return event;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance#getEventTask()
     */
    @Override
    public IEventTask getEventTask() {
        return (IEventTask) super.getTask();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.IEventTaskInstance#clone()
     */
    @Override
    public synchronized IEventTaskInstance clone() {
        return (IEventTaskInstance) super.clone();
    }

}
