//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import static de.ugoe.cs.autoquest.usability.UsabilitySmellDescription.DATA_ENTRY_METHOD_CHANGE;

import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.autoquest.usability.UsabilitySmell;

/**
 *
 */
public class DataEntryMethodChangeRuleTest extends AbstractUsabilityEvaluationTC {

    /**
     *
     */
    @Before
    public void setUp() {
        //UsabilitySmellIntensity.defaultCoverageQuantile = 0;
    }
    
    /**
     *
     */
    @Test
    public void testNoEntryMethodChange_01() {
        DataEntryMethodChangeRule rule = new DataEntryMethodChangeRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Interaction elem1 {}" +
            "  Interaction elem1 {}" +
            "}";
        
        // no smell expected, as there are no changes between mouse and keyboard
        UsabilitySmell[] expectedSmells = new UsabilitySmell[] {  };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }
    
    /**
     *
     */
    @Test
    public void testNoEntryMethodChange_02() {
        DataEntryMethodChangeRule rule = new DataEntryMethodChangeRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    Interaction elem1 {}" +
            "    Interaction elem2 {}" +
            "  }" +
            "}";
        
        // no smell expected, as there are no changes between mouse and keyboard
        UsabilitySmell[] expectedSmells = new UsabilitySmell[] {  };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }
    
    /**
     *
     */
    @Test
    public void testNoEntryMethodChange_03() {
        DataEntryMethodChangeRule rule = new DataEntryMethodChangeRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    MouseClick elem1 {}" +
            "    MouseClick elem2 {}" +
            "  }" +
            "}";
        
        // no smell expected, as there are no changes between mouse and keyboard
        UsabilitySmell[] expectedSmells = new UsabilitySmell[] {  };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }
    
    /**
     *
     */
    @Test
    public void testNoEntryMethodChange_04() {
        DataEntryMethodChangeRule rule = new DataEntryMethodChangeRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    TextInput elem1 {}" +
            "    TextInput elem2 {}" +
            "  }" +
            "}";
        
        // no smell expected, as there are no changes between mouse and keyboard
        UsabilitySmell[] expectedSmells = new UsabilitySmell[] {  };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }

    /**
     *
     */
    @Test
    public void testEntryMethodChange_01() {
        DataEntryMethodChangeRule rule = new DataEntryMethodChangeRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    MouseClick elem1 {}" +
            "    TextInput elem2 {}" +
            "  }" +
            "}";
        
        UsabilitySmell[] expectedSmells = new UsabilitySmell[]
            { new UsabilitySmell(UsabilitySmellIntensity.getIntensity(0),
                                  DATA_ENTRY_METHOD_CHANGE) };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }

    /**
     *
     */
    @Test
    public void testEntryMethodChange_02() {
        DataEntryMethodChangeRule rule = new DataEntryMethodChangeRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence {" +
            "    TextInput elem1 {}" +
            "    MouseClick elem2 {}" +
            "  }" +
            "}";
        
        UsabilitySmell[] expectedSmells = new UsabilitySmell[]
            { new UsabilitySmell(UsabilitySmellIntensity.getIntensity(0),
                                  DATA_ENTRY_METHOD_CHANGE) };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }

    /**
     *
     */
    @Test
    public void testEntryMethodChange_03() {
        DataEntryMethodChangeRule rule = new DataEntryMethodChangeRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence seq1 {" +
            "    Selection sel1 {" +
            "      TextInput elem2 {}" +
            "    }" +
            "    MouseClick elem1 {}" +
            "  }" +
            "  Sequence seq1 {" +
            "    Selection sel1 {" +
            "      MouseClick elem2 {}" +
            "    }" +
            "    MouseClick elem1 {}" +
            "  }" +
            "}";
        
        UsabilitySmell[] expectedSmells = new UsabilitySmell[]
            { new UsabilitySmell(UsabilitySmellIntensity.getIntensity(0),
                                  DATA_ENTRY_METHOD_CHANGE) };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }

    /**
     *
     */
    @Test
    public void testEntryMethodChange_04() {
        DataEntryMethodChangeRule rule = new DataEntryMethodChangeRule();

        // ===== check =====
        String spec =
            "UserSession {" +
            "  Sequence seq1 {" +
            "    MouseClick elem1 {}" +
            "    Selection sel1 {" +
            "      TextInput elem2 {}" +
            "    }" +
            "  }" +
            "  Sequence seq1 {" +
            "    MouseClick elem1 {}" +
            "    Selection sel1 {" +
            "      MouseClick elem2 {}" +
            "    }" +
            "  }" +
            "  Sequence seq1 {" +
            "    MouseClick elem1 {}" +
            "    Selection sel1 {" +
            "      MouseClick elem2 {}" +
            "    }" +
            "  }" +
            "  Sequence seq1 {" +
            "    MouseClick elem1 {}" +
            "    Selection sel1 {" +
            "      MouseClick elem2 {}" +
            "    }" +
            "  }" +
            "  Sequence seq1 {" +
            "    MouseClick elem1 {}" +
            "    Selection sel1 {" +
            "      MouseClick elem2 {}" +
            "    }" +
            "  }" +
            "  Sequence seq1 {" +
            "    MouseClick elem1 {}" +
            "    Selection sel1 {" +
            "      MouseClick elem2 {}" +
            "    }" +
            "  }" +
            "  Sequence seq1 {" +
            "    MouseClick elem1 {}" +
            "    Selection sel1 {" +
            "      MouseClick elem2 {}" +
            "    }" +
            "  }" +
            "  Sequence seq1 {" +
            "    MouseClick elem1 {}" +
            "    Selection sel1 {" +
            "      MouseClick elem2 {}" +
            "    }" +
            "  }" +
            "}";
        
        UsabilitySmell[] expectedSmells = new UsabilitySmell[]
            { new UsabilitySmell(UsabilitySmellIntensity.getIntensity(0),
                                  DATA_ENTRY_METHOD_CHANGE) };

        assertUsabilityEvaluationResult(expectedSmells, rule.evaluate(createTaskModel(spec)));
    }
}
