//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

// TODO: Auto-generated Javadoc
/**
 * <p>
 * the instance of an {@link ISequence}. The instance has the same number of
 * children as the sequence it represents.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface ISequenceInstance extends ITaskInstance, ITaskInstanceList {

	/**
	 * <p>
	 * clones this task instance by creating exact clones of each contained
	 * instance in their order
	 * </p>.
	 *
	 * @return a clone of the task instance
	 */
	@Override
	public ISequenceInstance clone();

	/**
	 * <p>
	 * returns the task related to the instance, i.e. the sequence.
	 * </p>
	 * 
	 * @return as described
	 */
	public ISequence getSequence();

}
