package de.ugoe.cs.eventbench.efg.commands;

import java.io.File;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.efg.data.EFGEvent;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import edu.umd.cs.guitar.model.IO;
import edu.umd.cs.guitar.model.data.StepType;
import edu.umd.cs.guitar.model.data.TestCase;

public class CMDefgTestCasesToSequences implements Command {

	@Override
	public void run(List<Object> parameters) {
		String foldername;
		String sequencesName = "sequences";
		try {
			foldername = (String) parameters.get(0);
			if( parameters.size()>=2 ) {
				sequencesName = (String) parameters.get(1);
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		File folder = new File(foldername);
		// TODO would be more robust with filter
		File[] testcaseFiles = folder.listFiles();
		Collection<List<Event<?>>> sequences = new LinkedList<List<Event<?>>>();
		for( File testcaseFile : testcaseFiles ) {
			Console.traceln("Loading from file " + testcaseFile.getAbsolutePath());
			TestCase testcase = (TestCase) IO.readObjFromFile(testcaseFile.getAbsolutePath(), TestCase.class);
			List<StepType> steps = testcase.getStep();
			List<Event<?>> sequence = new LinkedList<Event<?>>();
			for( StepType step : steps ) {
				step.getEventId();
				sequence.add(new EFGEvent(step.getEventId()));
				/*
				 * Problem: widgetId unknown!
				 * Therefore, the events will not be equal to those in the
				 * generated from a EFG. 
				 */ 
			}
			sequences.add(sequence);
		}
		if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
			Console.traceln("Old data \"" + sequencesName + "\" overwritten");
		}
		
	}

	@Override
	public void help() {
		Console.println("Usage: efgTestCasesToSequences <folder> {<sequencesName>}");
	}

}
