//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usageprofiles;

import java.io.Serializable;

/**
 * <p>
 * The symbol strategy is used in a trie for comparing symbols and for storing symbols in maps.
 * The symbol strategy can be changed to improve the performance of the trie depending on the type
 * of symbols.
 * </p>
 * 
 * @author Patrick Harms
 * 
 * @param <T>
 *            Type of the symbols that are compared and stored
 * @see Trie
 */
public interface SymbolStrategy<T> extends Serializable {

    /**
     * <p>
     * Returns a comparator for symbols that can be used to compare two symbols
     * </p>
     *
     * @return a comparator for symbols
     * 
     * @see SymbolComparator
     */
    public SymbolComparator<T> getSymbolComparator();

    /**
     * <p>
     * returns a new empty map for storing symbols and associated values. The symbols are the
     * keys of the map.
     * </p>
     *
     * @return as described
     * 
     * @see SymbolMap
     */
    public <V> SymbolMap<T, V> createSymbolMap();

    /**
     * <p>
     * returns a copy of the provided map for storing symbols and associated values.
     * </p>
     *
     * @return as described
     * 
     * @see SymbolMap
     */
    public <V> SymbolMap<T, V> copySymbolMap(SymbolMap<T, V> other);

}
