//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class TaskTreeUtils {
    
    /**
     *
     */
    public static boolean isChild(ITask potentialChild, ITask potentialParent) {
        if (potentialParent instanceof IStructuringTemporalRelationship) {
            for (ITask child : ((IStructuringTemporalRelationship) potentialParent).getChildren()) {
                if (child.equals(potentialChild) || isChild(potentialChild, child)) {
                    return true;
                }
            }
        }
        else if (potentialParent instanceof IMarkingTemporalRelationship) {
            ITask child = ((IMarkingTemporalRelationship) potentialParent).getMarkedTask();
            if (child.equals(potentialChild) || isChild(potentialChild, child)) {
                return true;
            }
        }
        
        return false;
    }

    /**
     *
     */
    public static Set<ISequence> getMostProminentTasks(ITaskModel        model,
                                                       Collection<ITask> tasks)
    {
        List<ISequence> sequences = new LinkedList<>();
        
        for (ITask task : tasks) {
            if (task instanceof ISequence) {
                sequences.add((ISequence) task);
            }
        }
        
        return getMostProminentSequences(model, sequences);
    }

    /**
     *
     */
    public static Set<ISequence> getMostProminentSequences(ITaskModel            model,
                                                           Collection<ISequence> tasks)
    {
        Map<Integer, List<ISequence>> sortedSequences = new HashMap<>();
        
        int maxCoverage = 0;
        
        for (ITask task : tasks) {
            int coveredEvents =
                    model.getTaskInfo((ISequence) task).getMeasureValue(TaskMetric.EVENT_COVERAGE);

            List<ISequence> sequencesWithSameCoverage = sortedSequences.get(coveredEvents);

            if (sequencesWithSameCoverage == null) {
                sequencesWithSameCoverage = new LinkedList<>();
                sortedSequences.put(coveredEvents, sequencesWithSameCoverage);
            }

            sequencesWithSameCoverage.add((ISequence) task);

            maxCoverage = Math.max(maxCoverage, coveredEvents);
        }
        
        Set<ISequence> result = new HashSet<>();
        
        for (int i = maxCoverage; i > 0; i--) {
            List<ISequence> sequencesWithSameCoverage = sortedSequences.get(i);
            
            if (sequencesWithSameCoverage != null) {
                result.addAll(sequencesWithSameCoverage);
                
                if (result.size() * 5 >= tasks.size()) {
                    break;
                }
            }
        }
        
        return result;
    }
    
    /**
     *
     */
    private TaskTreeUtils() { /* prevent instantiation */ }
}
