//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.commands.misc;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;

import de.ugoe.cs.autoquest.CommandHelpers;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command that saves an object contained in the {@link GlobalDataContainer}
 * through serialization.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDsaveObject implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		String objectName;
		try {
			filename = (String) parameters.get(0);
			objectName = (String) parameters.get(1);
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

		Object dataObject = GlobalDataContainer.getInstance().getData(
				objectName);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(objectName);
			return;
		}

		FileOutputStream fos = null;
		ObjectOutputStream out = null;
		try {
			fos = new FileOutputStream(filename);
			out = new ObjectOutputStream(fos);
			out.writeObject(dataObject);
			out.close();
		} catch (IOException ex) {
			Console.logException(ex);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "saveObject <filename> <objectName>";
	}

}
