//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.jfcmonitor;

import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;

/**
 * <p>
 * A ComponentListener responsible for monitoring adding and removing of GUI components
 * </p>
 * 
 * @author Fabian Glaser
 * @version 1.0
 */
public class JFCContainerListener implements ContainerListener {
	 /**
     * <p>
     * Writer for logging events.
     * </p>
     */
    final private JFCMonitorOutputWriter outputWriter;	
	
    /**
     * <p>
     * Constructor. Creates a new JFCContainerListener with a given {@link JFCMonitorOutputWriter}, where the
     * monitored information is logged.
     * </p>
     * 
     * @param outputWriter
     *            writer for the logged information
     */
    public JFCContainerListener(JFCMonitorOutputWriter outputWriter) {
        this.outputWriter = outputWriter;
    }

	@Override
	public void componentAdded(ContainerEvent e) {
		Component src = e.getChild();
		if (!JFCComponent.isKnown(src)){
			JFCComponent.add(src);
			JFCComponent jfcComponent = JFCComponent.find(src);
			outputWriter.write(jfcComponent.getXML());
			outputWriter.write(jfcComponent.printChildren());
		}		
	}

	@Override
	public void componentRemoved(ContainerEvent e) {
		//System.out.println("Component has been removed...");
	}

}