//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.keyboardmaps;

import java.util.Locale;

/**
 * <p>
 * Creates keyboard maps.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class KeyboardMapFactory {

    /**
     * <p>
     * Constructor. Private to prevent initialization of this class.
     * </p>
     */
    private KeyboardMapFactory() {
    }

    /**
     * <p>
     * Returns a {@link KeyboardMap} for the given {@link Locale}.
     * </p>
     *
     * @param locale the locale
     * @return the keyboard map
     */
    public static KeyboardMap createKeyboardMap(Locale locale) {
        KeyboardMap keyboardMap = new KeyboardMap(locale);
        keyboardMap.init();
        return keyboardMap;
    }
}
