package de.ugoe.cs.autoquest.plugin.alignment.seqgen;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.tasktrees.manager.TaskTreeManager;
import de.ugoe.cs.autoquest.tasktrees.taskequality.TaskEquality;
import de.ugoe.cs.autoquest.tasktrees.temporalrelation.TaskHandlingStrategy;
import de.ugoe.cs.autoquest.tasktrees.temporalrelation.TaskInstanceComparator;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskBuilder;
import de.ugoe.cs.autoquest.usageprofiles.SymbolMap;
import de.ugoe.cs.util.console.Console;


public class SimpleSequenceGenerator implements SequenceGenerator, Serializable {

	private ArrayList<NumberSequence> numberseqs;


	public SimpleSequenceGenerator() {
		this.numberseqs = new ArrayList<NumberSequence>();
	
	}
	
	public void print() {
		for (NumberSequence sequence : numberseqs) {
				System.out.println(sequence.toString());
		}
		
	}
	
	public void generate(Collection<List<Event>> sequences) {

	
		if (sequences != null) {
			TaskTreeManager ttm = new TaskTreeManager();
			
			ttm.createTaskModel(sequences);
			
			TaskHandlingStrategy preparationTaskHandlingStrategy  = new TaskHandlingStrategy(TaskEquality.SEMANTICALLY_EQUAL);
			SymbolMap<ITaskInstance, ITask> uniqueTasks = preparationTaskHandlingStrategy
					.createSymbolMap();
			TaskInstanceComparator comparator = preparationTaskHandlingStrategy
					.getTaskComparator();
			ITask task;
			ITaskBuilder taskBuilder = new TaskBuilder();

			List<IUserSession> sessions = ttm.getTaskModel().getUserSessions();
			
			for (IUserSession session : sessions) {
				//Creating a new sequence that just consists of integers
				NumberSequence templist = new NumberSequence(session.size()) ;
				for (int i = 0; i < session.size(); i++) {
					ITaskInstance taskInstance = session.get(i); 
					task = uniqueTasks.getValue(taskInstance);

					if (task == null) {
						uniqueTasks.addSymbol(taskInstance,
								taskInstance.getTask());
				
								templist.getSequence()[i]=taskInstance.getTask().getId();
								
					} else {
						taskBuilder.setTask(taskInstance, task);
						templist.getSequence()[i]=task.getId();
						
					}
					
				}
				
				comparator.clearBuffers();
				numberseqs.add(templist);
			}
			
		}

	}


	public NumberSequence get(int index) {
		return numberseqs.get(index);
	}


	public int sequenceCount() {
		return numberseqs.size();
	}

}
	