//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.util.HashMap;
import java.util.Map;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.tasktrees.treeifc.TaskMetric;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class EventCoverageRatioRule implements UsabilityEvaluationRule {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.usability.UsabilityEvaluationRule#evaluate(TaskTree)
     */
    @Override
    public UsabilityEvaluationResult evaluate(ITaskModel taskModel) {
        UsabilityEvaluationResult results = new UsabilityEvaluationResult(taskModel);

        checkForImportantTasks(results, taskModel);

        return results;
    }

    /**
     * 
     */
    private void checkForImportantTasks(UsabilityEvaluationResult results, ITaskModel taskModel) {
        for (ITask task : taskModel.getTasks()) {
            // only sequences are important
            if (task instanceof ISequence) {
                ISequence sequence = (ISequence) task;
                int ratio = taskModel.getTaskInfo(sequence).getMeasureValue
                    (TaskMetric.EVENT_COVERAGE_RATIO);

                UsabilitySmellIntensity severity =
                    UsabilitySmellIntensity.getIntensity(ratio, sequence, taskModel);

                if (severity != null) {
                    Map<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("task", sequence);
                    parameters.put("ratio", (ratio / 10));

                    results.addSmell(sequence, severity,
                                     UsabilitySmellDescription.HIGH_EVENT_COVERAGE, parameters);
                }
            }
        }
    }
}
