//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.httpmonitor;

import de.ugoe.cs.autoquest.plugin.http.logdata.HttpExchange;

/**
 * <p>
 * an exchange handler to be used either by the monitor or the proxy to handle recorded exchanges.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface HttpMonitorExchangeHandler extends HttpMonitorComponent {

    /**
     * <p>
     * handles a newly received exchange
     * </p>
     * 
     * @param httpExchange the exchange to be handled
     */
    void handleHttpExchange(HttpExchange httpExchange);

}
