//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.guimodel;

import java.io.Serializable;

/**
 * <p>
 * Common interface for views in GUI. What is considered a view depends strongly on the concrete
 * type of the GUI. For example, for web sites it may be any single page or a set of pages. For a
 * desktop application, it may be modal dialogs and the main view.
 * </p>
 * 
 * @version 1.1
 * @author Patrick Harms, Steffen Herbold
 */
public interface IGUIView extends Serializable {

    /**
     * <p>
     * Returns true, if the view is somewhat modal, i.e., it must be closed to see another view.
     * </p>
     * 
     * @return true if the view is modal; false otherwise
     */
    public boolean isModal();

    /**
     * <p>
     * Defines that {@link IGUIView} implementations have to define equals.
     * </p>
     * 
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object other);

    /**
     * <p>
     * Defines that {@link IGUIView} implementations have to define hashCode.
     * </p>
     * 
     * @see Object#hashCode()
     */
    @Override
    public int hashCode();
}
