//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.commands.misc;

import java.util.List;

import de.ugoe.cs.autoquest.CommandHelpers;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.FileOutputListener;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to start a {@link FileOutputListener}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDstartFileListener implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		try {
			filename = (String) parameters.get(0);
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

		FileOutputListener listener = new FileOutputListener(filename);
		listener.start();
		if (GlobalDataContainer.getInstance().addData(filename, listener)) {
			CommandHelpers.dataOverwritten(filename);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "startFileListener <filename>";
	}

}
