/*
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.LinkedList;

import de.ugoe.cs.autoquest.tasktrees.treeifc.DefaultTaskTraversingVisitor;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;

// TODO: Auto-generated Javadoc
/**
 * The Class EventTaskInstancesListGenerator.
 */
public class EventTaskInstancesListGenerator extends
		DefaultTaskTraversingVisitor {

	/** The eventlist. */
	private LinkedList<IEventTaskInstance> eventlist;

	/**
	 * Instantiates a new event task instances list generator.
	 */
	public EventTaskInstancesListGenerator() {
		eventlist = new LinkedList<IEventTaskInstance>();
	}

	/**
	 * Gets the eventlist.
	 *
	 * @return the eventlist
	 */
	public LinkedList<IEventTaskInstance> getEventlist() {
		return eventlist;
	}

	/**
	 * Sets the eventlist.
	 *
	 * @param eventlist the new eventlist
	 */
	public void setEventlist(LinkedList<IEventTaskInstance> eventlist) {
		this.eventlist = eventlist;
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.treeifc.DefaultTaskTraversingVisitor#visit(de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask)
	 */
	@Override
	public void visit(IEventTask eventTask) {
		if (eventTask.getInstances().size() > 0) {
			final IEventTaskInstance eti = (IEventTaskInstance) eventTask
					.getInstances().iterator().next();
			// System.out.println("Adding eventtaskinstance to list: " + eti);
			eventlist.add(eti);
		}
	}

}
