//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;

// TODO: Auto-generated Javadoc
/**
 * <p>
 * a task instance scope rule is able to detected temporal relationships between
 * the children of a task instance provided to the {@link #apply(ITaskInstance)}
 * method. A rule creates temporal relationships between the task instances,
 * i.e. substructures in the task tree, if it detects a temporal relationship
 * and instantiates the temporal relationships accordingly.
 * </p>
 * 
 * @author Patrick Harms
 */
interface ITaskInstanceScopeRule extends ITemporalRelationshipRule {

	/**
	 * <p>
	 * applies the rule to the given task instance. The returned rule
	 * application result is null, if the rule can not be applied, i.e. it does
	 * not detect a temporal relationship. It returns a rule application result
	 * with a status {@link RuleApplicationStatus#RULE_APPLICATION_FINISHED} if
	 * the rule was applied. The result contains all newly created parent tasks
	 * and task instances.
	 * </p>
	 * 
	 * @param taskInstance
	 *            the task instances to apply the rule on
	 * 
	 * @return the rule application result as described.
	 */
	RuleApplicationResult apply(ITaskInstance taskInstance);

}
