//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

// TODO: Auto-generated Javadoc
/**
 * <p>
 * Provides extended information about a specific task, such as statistics about
 * task occurrences, etc. It contains measures for different metrics determined
 * for a task.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface ITaskInfo {

	/**
	 * <p>
	 * represents a measure for a specific metric
	 * </p>.
	 *
	 * @author Patrick Harms
	 */
	public interface IMeasure {

		/**
		 * <p>
		 * returns the metric of the measure
		 * </p>.
		 *
		 * @return as described
		 */
		public TaskMetric getMetric();

		/**
		 * <p>
		 * returns the value of the measure
		 * </p>.
		 *
		 * @return as described
		 */
		public int getValue();

		/**
		 * <p>
		 * returns the value of the measure if the task was observed in a
		 * specific context, i.e. parent task
		 * </p>
		 *
		 * @param context the context
		 * @return as described
		 */
		public int getValue(ITask context);

	}

	/**
	 * <p>
	 * returns all available measures
	 * </p>.
	 *
	 * @return as described
	 */
	public IMeasure[] getMeasures();

	/**
	 * <p>
	 * returns the value of the measure identified through the given metric
	 * </p>.
	 *
	 * @param metric            the metric for which the value is to be returned
	 * @return as described
	 */
	public int getMeasureValue(TaskMetric metric);

	/**
	 * <p>
	 * returns the value of the measure identified through the given metric if
	 * the task is observed in the given context, i.e. parent task. The result
	 * is Integer.MIN_VALUE if there is no value for this measure in a context.
	 * </p>
	 *
	 * @param metric
	 *            the metric for which the value is to be returned
	 * @param context
	 *            the context for which the measure value is to be returned
	 * 
	 * @return as described
	 */
	public int getMeasureValue(TaskMetric metric, ITask context);

	/**
	 * <p>
	 * returns the task to which these infos belong
	 * </p>.
	 *
	 * @return as described
	 */
	public ITask getTask();

}
