//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.commands.usage;

import java.util.List;
import java.util.Random;

import de.ugoe.cs.autoquest.usageprofiles.FirstOrderMarkovModel;
import de.ugoe.cs.autoquest.usageprofiles.HighOrderMarkovModel;
import de.ugoe.cs.autoquest.usageprofiles.TrieBasedModel;

/**
 * <p>
 * Command to train first-order and high-order Markov models.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 2.0
 */
public class CMDtrainMarkovModel extends AbstractTrainCommand {

	/**
	 * <p>
	 * Order of the Markov model.
	 * </p>
	 */
	int order;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "trainMarkovModel <modelname> <sequencesName> {<order>}";
	}

	/**
	 * <p>
	 * Handles the parameter order.
	 * </p>
	 * 
	 * @see de.ugoe.cs.autoquest.commands.usage.AbstractTrainCommand#handleOptionalParameters(java.util.List)
	 */
	@Override
	void handleAdditionalParameters(List<Object> parameters) throws Exception {
		if (parameters.size() >= 3) {
			order = Integer.parseInt((String) parameters.get(2));
		} else {
			order = 1;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.ui.commands.AbstractTrainCommand#createModel()
	 */
	@Override
	TrieBasedModel createModel() {
		if (order == 1) {
			return new FirstOrderMarkovModel(new Random());
		} else {
			return new HighOrderMarkovModel(order, new Random());
		}
	}

}
