//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IMarkingTemporalRelationship;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

// TODO: Auto-generated Javadoc
/**
 * <p>
 * this is the default implementation of the interface
 * {@link IMarkingTemporalRelationship}. It does not do anything fancy except
 * implementing the interface.
 * </p>
 * 
 * @author Patrick Harms
 */
abstract class MarkingTemporalRelationship extends Task implements
		IMarkingTemporalRelationship {

	/** <p> default serial version UID </p>. */
	private static final long serialVersionUID = 1L;

	/** <p> the task marked through this marking temporal relationship </p>. */
	private ITask markedTask;

	/**
	 * <p>
	 * initializes this temporal relationship with a human readable name
	 * </p>.
	 *
	 * @param relationshipType            the human readable name of this temporal relationship
	 */
	MarkingTemporalRelationship(String relationshipType) {
		super(relationshipType);

		if ((relationshipType == null) || ("".equals(relationshipType))) {
			throw new IllegalArgumentException(
					"the relationship type must be something meaningful");
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.Task#clone()
	 */
	@Override
	public synchronized MarkingTemporalRelationship clone() {
		MarkingTemporalRelationship clone = null;
		clone = (MarkingTemporalRelationship) super.clone();

		if (markedTask != null) {
			clone.markedTask = markedTask.clone();
		}

		return clone;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.tasktrees.treeifc.IMarkingTemporalRelationship#
	 * getMarkedTask()
	 */
	@Override
	public ITask getMarkedTask() {
		return markedTask;
	}

	/**
	 * <p>
	 * used to set the marked task
	 * </p>.
	 *
	 * @param markedTask            the marked task to set
	 */
	protected void setMarkedTask(ITask markedTask) {
		this.markedTask = markedTask;

		super.setDescription(markedTask.toString());
	}

}
