//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.assertions;

import org.junit.*;

import de.ugoe.cs.autoquest.assertions.TextEqualsReplay;
import static org.junit.Assert.*;

/**
 * The class <code>TextEqualsReplayTest</code> contains tests for the class
 * <code>{@link TextEqualsReplay}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class TextEqualsReplayTest {

	private final static String ENDLINE = System.getProperty("line.separator");

	@Test
	public void testTextEqualsReplay_1() throws Exception {
		String expectedValue = "expectedValueString";
		String target = "targetString";

		TextEqualsReplay result = new TextEqualsReplay(expectedValue, target);

		assertNotNull(result);
		assertEquals(expectedValue, result.expectedValue);
		assertEquals(target, result.target);
	}

	@Test
	public void testTextEqualsReplay_2() throws Exception {
		String target = "targetString";

		TextEqualsReplay result = new TextEqualsReplay(null, target);

		assertNotNull(result);
		assertEquals(null, result.expectedValue);
		assertEquals(target, result.target);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testTextEqualsReplay_3() throws Exception {
		String expectedValue = "expectedValueString";

		new TextEqualsReplay(expectedValue, null);
	}

	@Test
	public void testGetReplay_1() throws Exception {
		TextEqualsReplay fixture = new TextEqualsReplay("", "");

		String result = fixture.getReplay();

		assertEquals(" <textEquals expectedValue=\"\">" + ENDLINE + "<target>"
				+ ENDLINE + ENDLINE + "</target>" + ENDLINE + "</textEquals>"
				+ ENDLINE, result);
	}

	@Test
	public void testGetReplay_2() throws Exception {
		TextEqualsReplay fixture = new TextEqualsReplay("expectedValueString",
				"targetString");

		String result = fixture.getReplay();

		assertEquals(" <textEquals expectedValue=\"expectedValueString\">"
				+ ENDLINE + "<target>" + ENDLINE + "targetString" + ENDLINE
				+ "</target>" + ENDLINE + "</textEquals>" + ENDLINE, result);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(TextEqualsReplayTest.class);
	}
}