//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

// TODO: Auto-generated Javadoc
/**
 * <p>
 * This is an implementation of the visitor pattern. Through this, it is
 * possible to effectively process a task model.
 * </p>
 * 
 * @author Alexander Deicke
 */
public interface ITaskVisitor {

	/**
	 * <p>
	 * method called for each visited event task.
	 * </p>
	 * 
	 * @param eventTask
	 *            the event task to be processed
	 */
	public void visit(IEventTask eventTask);

	/**
	 * <p>
	 * method called for each visited iteration.
	 * </p>
	 * 
	 * @param iteration
	 *            the iteration to be processed
	 */
	public void visit(IIteration iteration);

	/**
	 * <p>
	 * method called for each visited optional.
	 * </p>
	 * 
	 * @param optional
	 *            the optional to be processed
	 */
	public void visit(IOptional optional);

	/**
	 * <p>
	 * method called for each visited selection.
	 * </p>
	 * 
	 * @param selection
	 *            the selection to be processed
	 */
	public void visit(ISelection selection);

	/**
	 * <p>
	 * method called for each visited sequence.
	 * </p>
	 * 
	 * @param sequence
	 *            the sequence to be processed
	 */
	public void visit(ISequence sequence);

	/**
	 * <p>
	 * method called for each other kind of visited task (implemented to support
	 * future versions).
	 * </p>
	 * 
	 * @param task
	 *            the task to be processed
	 */
	public void visit(ITask task);

}
