//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptionalInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;

/**
 * <p>
 * Default implementation of {@link IOptionalInstance}.
 * </p>
 * 
 * @author Patrick Harms
 */
class OptionalInstance extends TaskInstance implements IOptionalInstance {

    /**
     * <p>
     * default serial version UID
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * the child of this task instance if any
     * </p>
     */
    private ITaskInstance child;
    
    /**
     * <p>
     * initializes this instance with the respective task model
     * </p>
     *
     * @param task  the task of which this is an instance
     */
    OptionalInstance(ITask task) {
        super(task);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.IOptionalInstance#getChild()
     */
    @Override
    public ITaskInstance getChild() {
        return child;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.IOptionalInstance#getOptional()
     */
    @Override
    public IOptional getOptional() {
        return (IOptional) super.getTask();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.ISequenceInstance#clone()
     */
    @Override
    public synchronized IOptionalInstance clone() {
        OptionalInstance clone = (OptionalInstance) super.clone();

        if (child != null) {
            clone.child = child.clone();
        }

        return clone;
    }

    /**
     * <p>
     * used to set the child of this task instance
     * </p>
     * 
     * @param child the new child of this instance
     */
    void setChild(ITaskInstance child) {
        if (child instanceof IOptionalInstance) {
            throw new IllegalArgumentException("the child of an optional can not be an optional");
        }
        
        this.child = child;
    }

}
