//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.httpmonitor;

/**
 * <p>
 * This is the default interface for an id generator that generates different ids on each new call
 * of {@link #getNextId()};
 * </p>
 * 
 * @author Patrick Harms
 */
public interface IdGenerator extends HttpMonitorComponent {

    /**
     * <p>
     * upon each call, this method returns a new id. The ids are returned so that they can be
     * ordered. This means, a new id is always larger than the previous one. But it is not
     * required, that the next id is larger by one than the previous one.
     * </p>
     *
     * @return the next unique id.
     */
    long getNextId();

}
