//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Convenience functions for working with events and sequences of events.
 * </p>
 * 
 * @author Steffen Herbold
 */
public class EventUtils {

    /**
     * <p>
     * prints a collection of sequences to the trace stream of the console
     * </p>
     * 
     * @param logLevel
     *            the trace log level
     * @param sequences
     *            sequences to be printed
     */
    public static void traceSequences(Level logLevel, Collection<List<Event>> sequences) {
        if (sequences != null) {
            for (List<Event> sequence : sequences) {
                traceSequence(logLevel, sequence);
            }
        }
    }

    /**
     * <p>
     * prints a sequence to the trace stream of the console
     * </p>
     * 
     * @param logLevel
     *            the trace log level
     * @param sequence
     *            sequence to be printed
     */
    public static void traceSequence(Level logLevel, List<Event> sequence) {
        if (sequence != null) {
            for (Event event : sequence) {
                Console.traceln(logLevel, event.toString());
            }
        }
    }

    /**
     * <p>
     * private constructor to prevent initialization
     * </p>
     */
    private EventUtils() {}
}
