//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usageprofiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.StringEventType;
import de.ugoe.cs.autoquest.usageprofiles.DeterministicFiniteAutomaton;

import java.util.Random;
import org.junit.*;

import static org.junit.Assert.*;

/**
 * The class <code>DeterministicFiniteAutomatonTest</code> contains tests for
 * the class <code>{@link DeterministicFiniteAutomaton}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class DeterministicFiniteAutomatonTest {

	Collection<List<Event>> sequences;

	@Test
	public void testDeterministicFiniteAutomaton_1() throws Exception {
		Random r = new Random();

		DeterministicFiniteAutomaton result = new DeterministicFiniteAutomaton(
				r);

		assertNotNull(result);
		assertEquals(2, result.trieOrder);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testDeterministicFiniteAutomaton_2() throws Exception {
		new DeterministicFiniteAutomaton(null);
	}

	@Test
	public void testGetProbability_1() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(new Event(new StringEventType("a")));
		context.add(new Event(new StringEventType("b")));

		Event symbol = new Event(new StringEventType("r"));

		double result = fixture.getProbability(context, symbol);

		assertEquals(1.0d, result, 0.0001);
	}

	@Test
	public void testGetProbability_2() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(new Event(new StringEventType("a")));

		Event symbol = new Event(new StringEventType("b"));

		double result = fixture.getProbability(context, symbol);

		assertEquals(1.0d / 4.0, result, 0.0001);
	}

	@Test
	public void testGetProbability_3() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(new Event(new StringEventType("a")));

		Event symbol = new Event(new StringEventType("c"));

		double result = fixture.getProbability(context, symbol);

		assertEquals(1.0d / 4.0, result, 0.0001);
	}

	@Test
	public void testGetProbability_4() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(new Event(new StringEventType("a")));

		Event symbol = new Event(new StringEventType("e"));

		double result = fixture.getProbability(context, symbol);

		assertEquals(0.0d, result, 0.0001);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testGetProbability_5() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(new Event(new StringEventType("a")));

		Event symbol = null;

		fixture.getProbability(context, symbol);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testGetProbability_6() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event> context = null;

		Event symbol = new Event(new StringEventType("a"));

		fixture.getProbability(context, symbol);
	}

	@Before
	public void setUp() throws Exception {
		List<Event> sequence = new ArrayList<Event>();
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("b")));
		sequence.add(new Event(new StringEventType("r")));
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("c")));
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("d")));
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("b")));
		sequence.add(new Event(new StringEventType("r")));
		sequence.add(new Event(new StringEventType("a")));

		sequences = new ArrayList<List<Event>>();
		sequences.add(sequence);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore()
				.run(DeterministicFiniteAutomatonTest.class);
	}
}