//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.util.List;
import java.util.Map;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class UsabilitySmell {

    /** */
    private ITask smellingTask;
    
    /** */
    private UsabilitySmellIntensity intensity;

    /** */
    private UsabilitySmellDescription description;

    /** */
    private Map<String, Object> descriptionParameters;

    /**
     *
     */
    UsabilitySmell(UsabilitySmellIntensity intensity, UsabilitySmellDescription description) {
        this(intensity, description, null);
    }
    
    /**
     *
     */
    UsabilitySmell(ITask                     smellingTask,
                   UsabilitySmellIntensity   intensity,
                   UsabilitySmellDescription description)
    {
        this(intensity, description, null);
    }

    /**
     *
     */
    UsabilitySmell(UsabilitySmellIntensity   intensity,
                   UsabilitySmellDescription description,
                   Map<String, Object>       parameters)
    {
        this(null, intensity, description, parameters);
    }

    /**
     *
     */
    UsabilitySmell(ITask                     smellingTask,
                   UsabilitySmellIntensity   intensity,
                   UsabilitySmellDescription description,
                   Map<String, Object>       parameters)
    {
        this.smellingTask = smellingTask;
        this.intensity = intensity;
        this.description = description;
        this.descriptionParameters = parameters;
    }

    /**
     * 
     */
    public ITask getSmellingTask() {
        return smellingTask;
    }

    /**
     * 
     */
    public UsabilitySmellIntensity getIntensity() {
        return intensity;
    }

    /**
     *
     */
    public void setIntensity(UsabilitySmellIntensity intensity) {
        this.intensity = intensity;
    }

    /**
     *
     */
    public void setDescription(UsabilitySmellDescription description) {
        this.description = description;
    }

    /**
     * 
     */
    public String getParameterizedDescription() {
        return description.toString(descriptionParameters);
    }

    /**
     * 
     */
    public List<Object> getDescriptionFragments() {
        return description.toFragmentList(descriptionParameters);
    }

    /*
     */
    public String getBriefDescription() {
        return description.getBriefDescription();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UsabilitySmell) {
            return description.equals(((UsabilitySmell) obj).description);
        }
        else {
            return false;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return description.hashCode();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        if (smellingTask == null) {
            return "UsabilitySmell(" + intensity + ", " + description.name() + ")";
        }
        else {
            return "UsabilitySmell(" + smellingTask + ", " + intensity + ", " +
                description.name() + ")";
        }
    }

}
