//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.android.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.AbstractDefaultGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIView;

/**
 * <p>
 * Base class for all Android GUI elements.
 * </p>
 * 
 * @version 1.0
 * @author Florian Unger
 */
public class ANDROIDGUIElement extends AbstractDefaultGUIElement {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Specification of the GUI Element
     * </p>
     */
    private ANDROIDGUIElementSpec specification;

    /**
     * <p>
     * Constructor. Creates a new JFCGUIElement.
     * </p>
     * 
     * @param specification
     *            specification of created GUI element
     * @param parent
     *            parent of the created GUI element; null means that the element is a top-level
     *            window
     */
    public ANDROIDGUIElement(ANDROIDGUIElementSpec specification, ANDROIDGUIElement parent) {
        super(specification, parent);
        this.specification = specification;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement#updateSpecification(de.ugoe.cs.autoquest
     * .eventcore .guimodel.IGUIElementSpec)
     */
    @Override
    public void updateSpecification(IGUIElementSpec furtherSpec) {
        // nothing do do here up to now.
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement#getView()
     */
    @Override
    public IGUIView getView() {
        throw new UnsupportedOperationException();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement#getDistanceTo(IGUIElement)
     */
    @Override
    public double getDistanceTo(IGUIElement otherElement) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IEventTarget#getPlatform()
     */
    @Override
    public String getPlatform() {
        return "Android";
    }

    /**
     * <p>
     * Returns the type of the GUI element, i.e., the name of its Android class.
     * </p>
     * 
     * @return the Android class name
     */
    public String getAndroidType() {
        return specification.getType();
    }
    
    /**
     * <p>
     * Returns the name of the GUI element.
     * </p>
     * 
     * @return the name
     */
    public String getName() {
        return specification.getName();
    }
    
    /**
     * <p>
     * Returns the path of the GUI element.
     * </p>
     * 
     * @return the path
     */
    public String getPath() {
        return specification.getPath();
    }
    
    /**
     * <p>
     * Returns the GUI element identifier.
     * </p>
     *
     * @return identifier of the GUI element
     */
    int getIndex() {
        return specification.getIndex();
    }
    
    /**
     * <p>
     * Returns the object hash of the GUI element.
     * </p>
     * 
     * @return the object hash
     */
    int getElementHash() {
        return specification.getElementHash();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String getStringIdentifier() {
        String str = this.toString();
        if (getParent() != null) {
            return str + "<-" + getParent().getStringIdentifier();
        }
        return str;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String str =
            getElementDescriptor() + "(" + getName() + "," + getElementHash() + "," + getPath() +
                "," + getIndex() + ")";
        return str;
    }

    /**
     * <p>
     * A short string describing the GUI element, e.g., Button, Canvas, or ScrollBar.
     * </p>
     * 
     * @return short element descriptor
     */
    protected String getElementDescriptor() {
        return "Default";
    }

}
