package de.ugoe.cs.autoquest.plugin.alignment.seqgen;
import de.ugoe.cs.autoquest.eventcore.Event;

import java.util.Collection;
import java.util.List;

public class RandomSequenceGenerator implements SequenceGenerator{

	private int min;
	private int max;
	private int count;
	
	
	public RandomSequenceGenerator(int min, int max, int count) {
		this.min = min;
		this.max = max;
		this.count = count;
	}
	
	public int[] generate(List<Event> eventList) {
		int[] result = new int[count];
		for (int i=0; i<count;i++) {
			result[i]= min + (int)(Math.random() * ((max - min)) + 1);
		}
		return result;
	}

	@Override
	public void generate(Collection<List<Event>> eventList) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public NumberSequence get(int index) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int sequenceCount() {
		return count;
	}
	
}
