/*
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.Collection;
import java.util.LinkedList;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

// TODO: Auto-generated Javadoc
/**
 * The Interface SubstitutionMatrix.
 */
public interface SubstitutionMatrix {

	/**
	 * Generate.
	 *
	 * @param uniqueTasks the unique tasks
	 */
	public void generate(Collection<ITask> uniqueTasks);

	/**
	 * Gets the gap penalty.
	 *
	 * @return the gap penalty
	 */
	public float getGapPenalty();

	/**
	 * Gets the score.
	 *
	 * @param pos1 the pos1
	 * @param pos2 the pos2
	 * @return the score
	 */
	public float getScore(int pos1, int pos2);

	/**
	 * Update.
	 *
	 * @param newlyGeneratedTasks the newly generated tasks
	 */
	public void update(LinkedList<ITask> newlyGeneratedTasks);

}
