//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import de.ugoe.cs.autoquest.tasktrees.taskequality.TaskEquality;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * <p>
 * symbol comparator implementation for task instances considering to task instances as equal if
 * they refer to the identical task object (comparison of object references).
 * </p>
 */
class TaskIdentityComparator extends TaskComparator {

    /**  */
    private static final long serialVersionUID = 1L;
    
    /**
     * <p>
     * initializes the parent class with the task equality {@link TaskEquality#IDENTICAL}.
     * </p>
     */
    public TaskIdentityComparator() {
        super(TaskEquality.IDENTICAL);
    }

    /* (non-Javadoc)
     * @see TaskInstanceComparator#equals(ITask, ITask)
     */
    @Override
    public boolean equals(ITask task1, ITask task2) {
        return task1 == task2;
    }        

}