//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.test;

import de.ugoe.cs.autoquest.eventcore.guimodel.AbstractDefaultGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIView;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 02.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class DummyGUIElement extends AbstractDefaultGUIElement implements IGUIElement {

    /**  */
    private static final long serialVersionUID = 1L;

    /** */
    private String name;

    /**
     *
     */
    public DummyGUIElement(String name) {
        this(name, null);
    }

    /**
     *
     */
    public DummyGUIElement(String name, IGUIElement parent) {
        super(null, parent);
        this.name = name;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IEventTarget#getPlatform()
     */
    @Override
    public String getPlatform() {
        return "Dummy";
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IEventTarget#getStringIdentifier()
     */
    @Override
    public String getStringIdentifier() {
        return name;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return name;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.GUIElement#equals(GUIElement)
     */
    public boolean equals(IGUIElement other) {
        return this == other;
    }

    @Override
    public void updateSpecification(IGUIElementSpec specToIntegrateElementFor) {
        // dummy
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement#getView()
     */
    @Override
    public IGUIView getView() {
        return null;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement#getDistanceTo(IGUIElement)
     */
    @Override
    public double getDistanceTo(IGUIElement otherElement) {
        if (this == otherElement) {
            return 0.0;
        }
        else {
            return 1.0;
        }
    }
}
