/*
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

// TODO: Auto-generated Javadoc
/**
 * A factory for creating AlignmentAlgorithm objects.
 */
public class AlignmentAlgorithmFactory {

	/**
	 * Creates the.
	 *
	 * @return the alignment algorithm
	 */
	public static AlignmentAlgorithm create() {
		Class<?> newclass;
		Object object = null;
		try {
			newclass = Class.forName(algorithmclass);
			object = newclass.newInstance();

		} catch (ClassNotFoundException | SecurityException
				| InstantiationException | IllegalAccessException
				| IllegalArgumentException e) {
			e.printStackTrace();
		}
		return (AlignmentAlgorithm) object;
	}

	/**
	 * Sets the default algorithm.
	 *
	 * @param algorithmname the new default algorithm
	 */
	public static void setDefaultAlgorithm(String algorithmname) {
		// TODO: check for valid algorihm class names here
		algorithmclass = algorithmname;
	}

	/** The algorithmclass. */
	private static String algorithmclass = "de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.SmithWatermanRepeated";
}
